###############################################
# FILE: doc.pat
# SUBJ: Analyzer documentation
# AUTH: AM
# CREATED: 30/May/05 11:04:06
# ANALYZER:	TAIParse is a general analyzer for English text.
#	The current version focuses on accurate POS tagging.
#	Blind testing on a Penn Treebank-like corpus is at 93%
#	accuracy.
#	Unlike other taggers, TAIParse also performs shallow parsing,
#	or chunking, and uses contexts such as clauses and sentences
#	to help tag text more accurately.
#	TAIParse is primarily manually built, with more generally
#	usable rules than are typically generated by an automatically
#	trained system.
#	With TAIParse, we have endeavored to use productive rules
#	and knowledge as far as possible.
#	The current version does little in the way of zoning text,
#	and assumes instead that it is given good sentences.  But
#	segmentation into sentences is deferred, so that zoning
#	methods can be integrated more easily.
###############################################

####################
####################
## NODE VARIABLES
####################
####################

# stem	= The stemmed text, eg, of head of a phrase.
# sem	= A semantic category.
#	5/13/06 AM. Changing this to an actively assigned thing.
#		Not just some default stem of a word.

# ne text	= Text for a named entity.
# ne		= Flag that node is a named entity.

# name		= Flag a named entity.

# nopos	    = (POS tagging) Things like punctuation, that don't
#	really need a part of speech.  (Not worrying about things
#	like period as eos vs decimal, as far as pos tagging, though
#	this could/should certainly be done.)
# posarr	= (POS tagging) In PRETAGGED text, as in Penn Treebank
#			  text, an array of answer-key values for pos.
# number = singular, plural, any, or some special values.
####################
## _TEXTZONE
####################

# func words = Count English functional words (e.g., "the").

####################
## _sent
####################

# clauses  = Count clauses in sentence.
# vg count = Count verb-group nodes in sentence.
#		(Can flag that a verb is "needed" in a clause.)

####################
## _clause
####################

# clause num = ordinal count of clause in its sentence.

# pattern  = Clausal pattern. Values:
#   nvnp  = np-vg-np-prep ("John held Mary up")
#	nvn   = np-vg-np, monotransitive verb. ("John likes Mary")
#	nvj   = np-copula-adj ("John is happy")
#	nvp   = phrasal/prepositional ("John works out")
#	nv    = intransitive verb. ("John walks")
#	    (Passive voice falls in here now.)
#	vnp, vn, vj, vp, v = ellipted subject. ("likes Mary")
#   n	  = lone np.
#   etc.

# vg node  = Pointer to main vg node in clause.
# vg count = Count verb-group nodes in clause.
# voice	   = Active/passive voice.

# last chunk = last main node name (v, n) in clause
# first = first node name in clause
# last  = last node name in clause



@CODE
L("hello") = 0;
@@CODE
